/*
* 19:36:20
* vjanssen
*/
package a0703c_k_Fahrzeug_Teil6;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Fuhrpark
{
	private ArrayList<Fahrzeug>fahrzeuge = new ArrayList<>();
		
	public Fuhrpark()
	{
		super();
	}
	
	public int anzahlFahrzeuge()
	{
		return fahrzeuge.size();
	}
		
	public void addFahrzeug(Fahrzeug fahrzeug)
	{
		this.fahrzeuge.add(fahrzeug);
	}
	
	public boolean delFahrzeug (int fahrzeugIndex)
	{
		if (fahrzeugIndex < 0 || fahrzeugIndex > fahrzeuge.size()) return false;
		else 
		{
			this.fahrzeuge.remove(fahrzeugIndex);
			return true;
		}
	}
	
	public ArrayList<String> maengelliste()
	{
		ArrayList<String> schaeden = new ArrayList<>();
		
		for(Fahrzeug f: fahrzeuge)
		{
			if (!f.getSchaeden().equals("keine Schden"))
			{
				String text = f.getKennzeichen() + " : " + f.getSchaeden();
				schaeden.add(text);
			}
		}		
		return schaeden;
	}
	
	public int anzahlWartungen()
	{
		int wartungen = 0;
		
		for(Fahrzeug f: fahrzeuge) if (f.getWartung()) wartungen++;
		return wartungen;
	}
		
	public boolean setSchaeden(int fahrzeugIndex, String schaeden)
	{
		if (fahrzeugIndex < 0 || fahrzeugIndex > fahrzeuge.size()) return false;
		else 
		{
			fahrzeuge.get(fahrzeugIndex).setSchaeden(schaeden);
			return true;
		}
	}
		
	public boolean setWartung(int fahrzeugIndex, boolean wartung)
	{
		if (fahrzeugIndex < 0 || fahrzeugIndex > fahrzeuge.size()) return false;
		else 
		{
			fahrzeuge.get(fahrzeugIndex).setWartung(wartung);
			return true;
		}
	}
	
	public double durchschnittAlter()
	{
		Calendar cal = new GregorianCalendar();
		int jahrAktuell 	= cal.get(Calendar.YEAR);
		int jahrSumme 		= 0;
		
		for(Fahrzeug f: fahrzeuge)
		{
			jahrSumme  = jahrSumme + (jahrAktuell - f.getZulassung()); 
		}
	
		return (double) jahrSumme / (double) this.anzahlFahrzeuge();
	}
	
	public double summeMaxZuladung()
	{
		double maxZuladungSumme = 0.0d;
		
		for(Fahrzeug f: fahrzeuge)
		{
			String klasse = f.getClass().getSimpleName();
			
			if (klasse.equals("Bus") || klasse.equals("LKW"))
			{
				maxZuladungSumme = maxZuladungSumme + ((LKW)f).getMaxZuladung();				
			}
		}	
		return maxZuladungSumme;
	}
	
	
	public void showStatistik()
	{
		System.out.println("===== Fuhrpark-Statistik =====");
		System.out.println("Anzahl Fahrzeuge:             " + this.anzahlFahrzeuge());
		System.out.println("Durchschnittsalter in Jahren: " + this.durchschnittAlter());
		System.out.println("Anzhal ausstehender Warungen: " + this.anzahlWartungen());
		System.out.println("Summe der MaxZuladungen:      " + this.summeMaxZuladung());
		System.out.println("MNGELLISTE:");
		for(String s: this.maengelliste())
		{
			System.out.println(s);
		}
		
	}
}
