package a0802d_u_TicTacToe;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;
	private static final Path pfad = Paths.get("d:\\myProjekt\\java\\a0802_4_u_TicTacToe\\Eingaben.save");

	public void meinProgramm (
		String[]	args,			// Programm Aufrufparameter
		Graphics2D 	g, 				// Universelles Zeichenobjekt
		int			eingabeIndex,	// Index der Eingabe
		String 		sEingabe, 		// Eingabe als Zeichenkette
		char 		cEingabe, 		// Erstes Zeichen der Eingabe
		double 		dEingabe, 		// Eingabe als Gleitkommazahl (wenn mglich!)
		int 		iEingabe)		// Eingabe als ganze Zahl (wenn mglich!)
	{
		if (cEingabe == 's' || cEingabe == 'S')				// Speichern
		{	
			_Eingabe.removeEingabe(_Eingabe.getIndex());	// Letzt Eingabe entfernen 
			
			try (ObjectOutputStream oos = 
					new ObjectOutputStream (
					   new BufferedOutputStream(
						 Files.newOutputStream(pfad))))
			{
				oos.writeObject(_Eingabe.getEingabeListe());
			}
			catch (IOException io)
			{
				System.out.println(io.toString());
			}
		}
		
		if (cEingabe == 'l' || cEingabe == 'L')			// Laden
		{
			try (ObjectInputStream ois = 
					new ObjectInputStream (
					   new BufferedInputStream (
					      Files.newInputStream(pfad))))
			{
				_Eingabe.setEingabeListe((ArrayList<String>) ois.readObject());
			}
			catch (Exception io)
			{
				System.out.println(io.toString());
			}
			
			eingabeIndex = _Eingabe.getIndex(); 		// Eingabeindex anpassen
		}		
		
		// In dm Array wird eine 1 fr Spieler Weiss und 10 fr Spieler Schwarz hinterlegt
		int[][] stellung = {{0,0,0},{0,0,0},{0,0,0}};
		
		int i = 0;
		do
		{
			String zug = _Eingabe.getString(i);								// Zug aus Eingabeliste
			if (ziehen(zug, stellung, i%2))		println(zug);				// Zug wenn OK ausfhren -> true / sonst false
			else								_Eingabe.removeEingabe(i);	// Falschen Zug zurcknehmen
			i=i+1;			
		}
		while(i<=_Eingabe.getIndex() && gewonnen(stellung) == -1);
		
		// Computer ist am Zug
		if (_Eingabe.getIndex()%2==0 && gewonnen(stellung) == -1)
		{
			String zug = bestimmeZug(stellung);
			ziehen(zug, stellung, 1);
			println(zug);
			_Eingabe.addEingabe(zug);
		}			
		
		// Kontrolle Spielende und Computerzug
		switch (gewonnen(stellung))
		{
		case 0: println ("WIESS\ngewinnt");break;
		case 1: println ("SCHWARZ\ngewinnt");break;
		case 2: println ("UNENTSCHIEDEN");break;
		}
				
		showStellung(g, stellung);		
	}
	
	/**
	 * Bestimmt einen zuflligen aber zulssigen Zug
	 * @param stellung Aktuelle Stellung
	 * @return String des Feldes z.B. "a1"
	 */
	public String bestimmeZug(int[][] stellung)
	{
		int x;
		int y;
		String buchstaben = "abc";
		String zug;
				
		
		for (int spieler = 1; spieler >=0; spieler--)
		{
			for (int i=0; i<stellung.length; i++)
			{
				for (int j=0; j<stellung[i].length; j++)
				{
					zug = "" + buchstaben.charAt(i) + (j+1);
					if (ziehen(zug, stellung, spieler)) 		// ziehe testweise alle mglichen Zge zunchst fr den Compuer, dann fr den Spieler
					{											// wehnn zug ausfhrbar
						int gewonnen = gewonnen(stellung);		// test ob Zug gewinnt
						loescheZug(zug, stellung);				// nimm Zug zurck
						if (gewonnen == spieler)
						{
							return zug;							// gib den Zug zurck
						}
					}
				}
			}
		}		
		
		do
		{
			x = (int) (Math.random()*3);
			y = (int) (Math.random()*3);
		}
		while(stellung[x][y] != 0);
		
		zug = "" + buchstaben.charAt(x) + (y+1);
		return zug;		
	}
	
	/**
	 * Kontrolliert das Spielende
	 * @param stellung Aktuelle Stellung
	 * @return 0 wenn Weiss gewinnt / 1 wenn Schwarz gewinnt / 2 unentschieden / -1 Spiel NICHT beendet
	 */
	public int gewonnen(int[][] stellung)
	{
		int[] a = {0,0,0,0,0,0,0,0}; 	// Auswertungsarray fr 3 Zeilen, 3 Spalten, 2 Diagonalen
		
		for (int i=0; i<3; i++)
		{			
			a[0] 	= a[0] + stellung[0][i];
			a[1] 	= a[1] + stellung[1][i];
			a[2] 	= a[2] + stellung[2][i];
			a[3]	= a[3] + stellung[i][0];
			a[4]	= a[4] + stellung[i][1];
			a[5]	= a[5] + stellung[i][2];
			a[6]	= a[6] + stellung[i][i];
			a[7]	= a[7] + stellung[i][2-i];
		}
		
		int unentschieden = 0;
		
		for (int i=0; i<a.length; i++)
		{
			int z = a[i] / 10;			// Zehner Stelle extrahieren
			int e = a[i] - (z*10);		// Einer Stelle extrahieren
			if (z == 3) 	return 1;	// Schwarz (10) gewinnt
			if (e == 3)		return 0;	// Weiss (1) gewinnt
			
			if (i < 3)
			{
				unentschieden = unentschieden + z + e;
			}
			if (unentschieden == 9) return 2; // Unentschieden
			
		}		
		return -1;		
	}
	
	/**
	 * Lscht eine Spielfugur vom Spielfeld
	 * @param zug Position der Spielfigur
	 * @param stellung Aktuelle Stellung
	 */
	public void loescheZug(String zug, int[][]stellung)
	{
		zug = zug.toLowerCase();
		String buchstaben	= "abc";
		String zahlen     	= "123";
		
		zug.trim();							// Zhrende Leerzeichen entfernen
		zug.replace("  +", " ");			// Leerzeichen in der Eingabe entfernen
		
		if (zug.length() == 2)
		{
			int x = buchstaben.indexOf(zug.charAt(0));
			int y = zahlen.indexOf(zug.charAt(1));
			stellung[x][y] = 0;
		}
	}
	
	/**
	 * Es wird der angegeben Zug ausgefhrt, wenn er zulssig ist.
	 * @param zug Position der zu setzendem Spielfigur
	 * @param stellung aktuelle Spielstellung
	 * @param spieler Spieler 0 = weiss / Spieler 1 = schwarz
	 * @return true wenn zug ok
	 */
	public boolean ziehen(String zug, int[][]stellung, int spieler)
	{
		zug = zug.toLowerCase();
		String buchstaben	= "abc";
		String zahlen     	= "123";
		
		zug.trim();							// Zhrende Leerzeichen entfernen
		zug.replace("  +", " ");			// Leerzeichen in der Eingabe entfernen
		
		if (zug.length() == 2)
		{
			int x = buchstaben.indexOf(zug.charAt(0));
			int y = zahlen.indexOf(zug.charAt(1));
		
			if (	x != -1			// Buchstabe aus abcdefgh
				&&	y != -1	)		// Zahl aus 12345678
			{
				if (stellung[x][y] == 0)
				{
					if (spieler == 0)	stellung[x][y] = 1;
					else				stellung[x][y] = 10;
					return true; 			
				}
			}
		}
		return false;
	}
	
	/**
	 * Zeigt die Stellung auf dem Fenster an
	 * @param g
	 * @param stellung
	 */
	public static void showStellung(Graphics2D g, int[][] stellung)
	{
		int xPos = 150;
		int yPos = 50;
		int bPos = 40;
		int aPos = 3;
		
		String buchstaben 	= "abc";
				
		for (int i=0; i<stellung.length; i++)
		{
			g.setColor(Color.BLACK);
			g.drawString(""+buchstaben.charAt(i), xPos + i*bPos + 5*aPos, yPos-5*aPos);
			g.drawString(""+(i+1), xPos - 5*aPos, yPos + i*bPos + 5*aPos);
			
			for (int j=0; j<stellung[i].length; j++)
			{
				int x = xPos + i*bPos;
				int y = yPos + j*bPos;
				
				if ((i+j)%2 == 0) 	g.setColor(Color.GRAY);
				else				g.setColor(Color.LIGHT_GRAY);
				g.fill3DRect(x, y, bPos, bPos, true);	
				
				int z = stellung[i][j];
				
				if (z==1) 
				{
					g.setColor(Color.WHITE);
					g.fillRect(x + aPos*3 , y + aPos*3, bPos-6*aPos, bPos-6*aPos);
				}
				if (z==10)
				{
					g.setColor(Color.DARK_GRAY);
					g.fillOval(x + aPos*2 , y + aPos*2, bPos-4*aPos, bPos-4*aPos);
				}				
			}
		}
	}
}
