package a0802e_k_Speicherplatzbedarf;

import java.io.IOException;
import java.nio.file.*;
import java.nio.file.attribute.*;

public class MyFileVisitor extends SimpleFileVisitor<Path> 
{
	private long speicherbedarf = 0;
	
    public FileVisitResult visitFile(Path p, BasicFileAttributes attr)
    {    	
    	if (attr.isRegularFile())
    	{
    		speicherbedarf = speicherbedarf + attr.size();
    	}
    	
    	System.out.println(p.getFileName() + " -> " + attr.size());
    	
    	return FileVisitResult.CONTINUE;
    }

    public FileVisitResult postVisitDirectory(Path p, IOException ioe)
    {
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult visitFileFailed(Path p, IOException ioe) 
    {
        System.out.println(ioe.toString());
        return FileVisitResult.CONTINUE;
    }
    
    public long getSpeicherbedarg()
    {
    	return this.speicherbedarf;
    }
}
