/*
* 06:30:30
* vjanssen
*/
package a0902c_k_Gehalt_Teil2_Zusatzaufgabe;

/*
 * Zusatzaufgabe fr Experten
 * 
 * Wenn in der Klasse Gehalt Klassenbezogene Increment und Decrement Methoden zur Vernderung der
 * Klassenvariablen Unter- und Obergrenze angeboten wrden, so knnte man auch diese Methoden
 * komplett ber Klassenmethodensperren oder ber das Klassenobjekt getClass() schtzen.
 * Dann sind aber immer beide Methoden gleichzeitig gesperrt, wenn eine der beiden Methoden aufgerufen wird.
 * Dadurch wrde dann zu viel Synchronisiert, da die Variablen ober- und untergrenze unabhngig voneinander sind.
 *     
 */

public class Gehalt
{
// Klassenvariablen
	private static double untergrenze	= 1000.0d;
	private static double obergrenze	= 5000.0d;
	
// Klassenmethoden
	public static void setUntergrenze(double untergrenze)
	{
		if (untergrenze < Gehalt.obergrenze) Gehalt.untergrenze = untergrenze;
	}
	
	public static double getUntergrenze()
	{
		return Gehalt.untergrenze;
	}
	
	public static void setObergrenze(double obergrenze)
	{
		if (Gehalt.untergrenze < obergrenze) Gehalt.obergrenze = obergrenze;
	}
	
	public static double getObergrenze()
	{
		return Gehalt.obergrenze;
	}	
	
// Objektvariablen	
	private double gehalt;
	
// Konstruktoren
	public Gehalt()
	{
		this.gehalt = Gehalt.untergrenze;				
	}
	
	public Gehalt(double gehalt)
	{
		this.setGehalt(gehalt);
	}
	
// Objektmethoden
	public synchronized void setGehalt(double gehalt)
	{
		if (gehalt < Gehalt.untergrenze)	this.gehalt = Gehalt.untergrenze;
		else
		{
			if (gehalt > Gehalt.obergrenze)	this.gehalt = Gehalt.obergrenze;
			else							this.gehalt = gehalt;
		}
	}
	
	public synchronized void inkrement()
	{
	// ANFANG Kritischer Bereich
		double speicher = this.gehalt + 1;													// Auslesen und dekrementieren
		try {Thread.sleep((int) (Math.random() * 100));}catch (InterruptedException ie) {} 	// Warten
		this.gehalt = speicher;																// Zurckschreiben
	// -ENDE- Kritischer Bereich
	}
	
	public synchronized void dekrement()
	{
	// ANFANG Kritischer Bereich
		double speicher = this.gehalt - 1;													// Auslesen und dekrementieren
		try {Thread.sleep((int) (Math.random() * 100));}catch (InterruptedException ie) {} 	// Warten
		this.gehalt = speicher;																// Zurckschreiben
	// -ENDE- Kritischer Bereich
	}
	
	public double getGehalt()
	{
		return this.gehalt;
	}

	public void showGehalt()
	{
		System.out.println("Gehalt:      " + this.gehalt);
	}
}
