/*
* 12:06:57
* vjanssen
*/
package a1002b_k_Geschwindigkeitstest_Teil2;

import java.util.Arrays;
import java.util.Scanner;

public class Start
{
	public static void sortiere(int d[])
	{
		quickSort(d, 0, d.length - 1);
	}

	public static void quickSort(int dosen[], int l, int r)
	{
		if (l < r)
		{
			int teile = teile(dosen, l, r);
			quickSort(dosen, l, teile - 1);
			quickSort(dosen, teile + 1, r);
		}
	}

	public static int teile(int d[], int l, int r)
	{
		int pivot, i, j, help;
		pivot = d[r]; i = l; j = r - 1;
		while (i <= j)
		{
			if (d[i] > pivot)
			{
				help = d[i]; d[i] = d[j];
				d[j] = help; j--;
			} else i++;
		}
		help = d[i]; d[i] = d[r];
		d[r] = help;
		return i;
	}
	
	public static void bubbleSort(int[] dosen)
	{
		int hilf;

		for (int j = 0; j < dosen.length; j++)
		{
			for (int i = 1; i < dosen.length; i++)
			{
				if (dosen[i] < dosen[i - 1])
				{
					hilf = dosen[i - 1];
					dosen[i - 1] = dosen[i];
					dosen[i] = hilf;
				}
			}
		}
	}
	
	public static void bubbleSortBesser(int[] dosen)
	{
		int hilf;
		boolean tausch;

		int j = dosen.length;
		
		do
		{
			tausch = false;
		
			for (int i = 1; i < j-1; i++)
			{
				if (dosen[i] < dosen[i - 1])
				{
					hilf = dosen[i - 1];
					dosen[i - 1] = dosen[i];
					dosen[i] = hilf;
					tausch = true;
				}
			}
			j--;
		}
		while (tausch);
	}

	public static void main(String[] args)
	{
		// Zahl eingeben
		System.out.println("Achtung keine Eingabekontrolle!");
		Scanner scanner = new Scanner(System.in);
		System.out.print("Anzahl der Zufallswerte: ");
		int anzahl = scanner.nextInt();
		scanner.close();
		
		int[] array 	= new int[anzahl];
		long vorher 	= 0;
		long nachher 	= 0;
		
		fuelleArray(array);
		showArray(array, 20);
		vorher = System.currentTimeMillis(); // Befehl vorher bekannt geben!
		Arrays.stream(array)
			.sorted()
			.limit(20)
			.forEach(i -> System.out.print(" " + i));
		nachher = System.currentTimeMillis();
		System.out.println("\nStrom -> Millisekunde: " + (nachher - vorher));
				
		fuelleArray(array);
		showArray(array, 20);
		vorher = System.currentTimeMillis(); // Befehl vorher bekannt geben!
		bubbleSort (array);
		showArray(array, 20);
		nachher = System.currentTimeMillis();
		System.out.println("BubleSort -> Millisekunde: " + (nachher - vorher));
		
		fuelleArray(array);
		showArray(array, 20);
		vorher = System.currentTimeMillis(); // Befehl vorher bekannt geben!
		bubbleSortBesser (array);
		showArray(array, 20);
		nachher = System.currentTimeMillis();
		System.out.println("BubleSort -> Millisekunde: " + (nachher - vorher));
		
		fuelleArray(array);
		showArray(array, 20);
		vorher = System.currentTimeMillis();
		sortiere(array);
		showArray(array, 20);
		nachher = System.currentTimeMillis();
		System.out.println("QuickSort -> Millisekunde: " + (nachher - vorher));
	}
	
	public static void fuelleArray(int[] array)
	{
		for (int i=0; i< array.length; i++)
		{
			array[i] = (int) (Math.random()*1000000+1);
		}
		System.out.println("\n -> Array zufllig befllt");
	}
	
	public static void showArray(int[] array, int anzahl) // Zusatzaufgabe
	{
		for (int i=0; i< array.length && i<anzahl; i++)
		{
			System.out.print(" " + array[i]);
		}
		System.out.println(" -> die Ersten " + anzahl + " Array-Elemente");
	}	
}
