package a1102b_f_Bewegen;

import java.awt.*;
import java.awt.event.*;
import java.util.ArrayList;

public class MeinFenster extends Frame
{
	private int x;
	private int y;
	private int b; //breite
	
	public MeinFenster()
	{
		super("MeinFenster");
		
		this.x = 50;
		this.y = 50;
		this.b = 50;		
		
		this.setSize(300,200);
		this.setLocation(50, 50);
				
		this.addWindowListener(new WindowAdapter()
		{	public void windowClosing(WindowEvent we)
			{	System.exit(0);		}
		}	);
		
		this.addKeyListener(new MyKeyListener());
		this.addMouseListener(new MyMouseListener());
		
		this.setVisible(true);
	}
	
	private void kontrolleKreisKoordinaten()
	{
		int minX 	= this.getInsets().left;
		int maxX 	= this.getWidth() - this.getInsets().right - this.b;
		int minY 	= this.getInsets().top;
		int maxY 	= this.getHeight() - this.getInsets().bottom - this.b;
		
		if (this.x < minX) this.x = minX;
		if (this.y < minY) this.y = minY;
		if (this.x > maxX) this.x = maxX;
		if (this.y > maxY) this.y = maxY;
	}
	
	public void paint(Graphics g)
	{
		this.kontrolleKreisKoordinaten();
		g.fillOval(x, y, b, b);
	}
	
	public class MyKeyListener extends KeyAdapter
	{
		public void keyPressed(KeyEvent ke)
		{
			switch (ke.getKeyCode())
			{
				case KeyEvent.VK_LEFT: x--; break;
				case KeyEvent.VK_RIGHT: x++; break;
				case KeyEvent.VK_UP: y--; break;
				case KeyEvent.VK_DOWN: y++; break;
			}			
			repaint();
		}
	}
	
	
	public class MyMouseListener extends MouseAdapter
	{
		public void mousePressed(MouseEvent me)
		{
			x = me.getX() - b/2;	// Koorektur auf den Kreismittelpunkt
			y = me.getY() - b/2;
	
			repaint();
		}
	}
	
}
