package a1103b_f_CheckboxGroup;

import java.awt.*;
import java.awt.event.*;

public class MeinFenster extends Frame
{
	private Color c = Color.WHITE;
	
	private CheckboxGroup cbg		= new CheckboxGroup();;
	private Checkbox cb_blau		= new Checkbox("BLAU", cbg, true);;
	private Checkbox cb_rot			= new Checkbox("ROT", cbg, false);;
	private Checkbox cb_gruen		= new Checkbox("GRN", cbg, false);;
	private Checkbox cb_klein		= new Checkbox("klein", false);;	
	private FlowLayout flowLayout	= new FlowLayout();
	
	public MeinFenster()
	{
		super("MeinFenster");
		this.setSize(300,200);
		this.setLocation(50, 50);
		this.setBackground(c);				
		
		this.setLayout(flowLayout);
		this.add(cb_blau);
		this.add(cb_rot);
		this.add(cb_gruen);
		this.add(cb_klein);
		
		this.cb_blau.addItemListener(new MyItemListener());
		this.cb_rot.addItemListener(new MyItemListener());
		this.cb_gruen.addItemListener(new MyItemListener());
		this.cb_klein.addItemListener(new MyItemListener());
		
		this.addWindowListener(new WindowAdapter()
		{	public void windowClosing(WindowEvent we)
			{	System.exit(0);		}
		}	);
		
		this.setVisible(true);
	}
		
	public void paint(Graphics g)
	{
		this.setBackground(c);	
		cb_blau.setBackground(c);
		cb_rot.setBackground(c);
		cb_gruen.setBackground(c);
		cb_klein.setBackground(c);
	}
	
	public class MyItemListener implements ItemListener
	{
		public void itemStateChanged(ItemEvent ie)
		{
			if (ie.getSource() == cb_blau)	c = Color.BLUE;
			if (ie.getSource() == cb_rot)	c = Color.RED;
			if (ie.getSource() == cb_gruen)	c = Color.GREEN;
			
			if (ie.getSource() == cb_klein)
			{
				if(ie.getStateChange() == ItemEvent.SELECTED)
				{
					cb_blau.setLabel("blau");
					cb_rot.setLabel("rot");
					cb_gruen.setLabel("grn");
				}
				else
				{
					cb_blau.setLabel("BLAU");
					cb_rot.setLabel("ROT");
					cb_gruen.setLabel("GRN");										
				}
			}
			
			repaint();
		}
	}
}
