package a1103c_f_Umrechnen;

import java.awt.*;
import java.awt.event.*;

public class MyFenster extends Frame implements ActionListener
{
	private static final long serialVersionUID = 1L;
	
	//Umrechnungskonstanten
	private final static float PS_TO_KW = 0.73f; 
	private final static float KW_TO_PS = 1.36f;
	private final static float C_TO_K = +273.15f; 
	private final static float K_TO_C = -273.15f;
	
	
	private TextField ps, kw;
	private TextField c, k;

	private Button um, end;

	public MyFenster()
	{
		super("Umrechnen"); 
		ps = new TextField("", 10);
		kw = new TextField("", 10);
		c  = new TextField("", 10);
		k  = new TextField("", 10);
		um  = new Button("Umrechnen");
		end = new Button("Beenden");
		
		//Layout
		Panel p1 = new Panel(); 
		p1.setLayout(new GridLayout(2, 4));
		p1.add(ps);	p1.add(new Label("=PS"));
		p1.add(kw);	p1.add(new Label("=KW"));
		p1.add(c);	p1.add(new Label("=C Celsius"));
		p1.add(k);	p1.add(new Label("=Kelvin"));
		
		Panel p2 = new Panel();
		p2.setLayout(new BorderLayout());
		p2.add(BorderLayout.CENTER, um);
		p2.add(BorderLayout.LINE_END, end);
		this.setLayout(new BorderLayout()); 											
		this.add(BorderLayout.PAGE_START, p1);
		this.add(BorderLayout.PAGE_END, p2);

		//Listener registrieren
		um.addActionListener(this); // Listener registrieren
		end.addActionListener(this);
		ps.addFocusListener(new MyFocusListener());
		kw.addFocusListener(new MyFocusListener());
		c.addFocusListener(new MyFocusListener());
		k.addFocusListener(new MyFocusListener());
		
		this.addWindowListener(new MyWindowListener(true)); // MyWindowListener

		this.setBackground(Color.lightGray); // Sonstige Fenstereinstellungen
		this.setSize(300, 150);
		this.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) 
	{
		if (e.getSource() == end)
		{
			System.exit(0);
		}
		if (e.getSource() == um)
		{
			try
			{
				String s_ps, s_kw, s_c, s_k;
				float f_ps, f_kw, f_c, f_k;
	
				// Texte einlesen
				s_ps = ps.getText();
				s_kw = kw.getText();
				s_c  = c.getText();
				s_k  = k.getText();
	
				if (!s_ps.equals("") && s_kw.equals(""))
				{
					f_ps = Float.valueOf(s_ps).floatValue();
					f_kw = PS_TO_KW * f_ps;
					s_kw = String.valueOf(f_kw);
					kw.setText(s_kw);
				}
				
				if (s_ps.equals("") && !s_kw.equals(""))
				{
					f_kw = Float.valueOf(s_kw).floatValue();
					f_ps = KW_TO_PS * f_kw;
					s_ps = String.valueOf(f_ps);
					ps.setText(s_ps);
				}
				
				if (!s_c.equals("") && s_k.equals(""))
				{
					f_c = Float.valueOf(s_c).floatValue();
					f_k = C_TO_K + f_c;
					s_k = String.valueOf(f_k);
					k.setText(s_k);
				}
				
				if (s_c.equals("") && !s_k.equals(""))
				{
					f_k = Float.valueOf(s_k).floatValue();
					f_c = K_TO_C + f_k;
					s_c = String.valueOf(f_c);
					c.setText(s_c);
				}
			}
			catch(Exception ex)
			{
				// Fehler bei Eingabe verbrennen...
			}
		}
	}

	class MyFocusListener extends FocusAdapter
	{
		public void focusGained(FocusEvent e)
		{
			if (e.getSource() == ps || e.getSource() == kw)
			{	
				ps.setText("");
				kw.setText("");
			}
			else
			{	
				c.setText("");
				k.setText("");
			}			
			repaint();
		}
	}

}
