package a1103d_f_Zylinderberechnung;

import java.awt.*;
import java.awt.event.*;

public class MeinFenster extends Frame implements ActionListener
{
	private char berechnung = 'U';
	private String einheit = "mm";
	
	private CheckboxGroup cb_berechnung		= new CheckboxGroup();
	private Checkbox cb_b_umfang			= new Checkbox("U Umfang", 		cb_berechnung, 	true);
	private Checkbox cb_b_grundflaeche		= new Checkbox("G Grundflche", cb_berechnung, 	false);
	private Checkbox cb_b_mantel			= new Checkbox("M Mantel", 		cb_berechnung, 	false);
	private Checkbox cb_b_oberflaeche		= new Checkbox("O Oberflche", 	cb_berechnung, 	false);
	private Checkbox cb_b_volumen			= new Checkbox("V Volumen",	 	cb_berechnung, 	false);

	private CheckboxGroup cb_einheit		= new CheckboxGroup();
	private Checkbox cb_e_mm				= new Checkbox("mm Millimeter",	cb_einheit, 	true);
	private Checkbox cb_e_cm				= new Checkbox("cm Zentimeter",	cb_einheit, 	false);
	private Checkbox cb_e_dm				= new Checkbox("dm Dezimeter",	cb_einheit, 	false);
	private Checkbox cb_e_m					= new Checkbox("m  Meter",		cb_einheit, 	false);
	private Checkbox cb_e_km				= new Checkbox("km Millimeter",	cb_einheit, 	false);
	
	private Label l_radius					= new Label ("Radius");
	private TextField tf_radius				= new TextField("0.0", 10);
	private Label l_hoehe					= new Label ("Hhe");
	private TextField tf_hoehe				= new TextField("0.0", 10);
	private Label l_ergebnis				= new Label ("Ergebnis:");
	private TextField tf_ergebnis			= new TextField("-", 10);
	private Button b_berechne				= new Button("Berechnen");
		
	private Panel p_radius 					= new Panel();
	private Panel p_hoehe 					= new Panel();
	private Panel p_eingabebereich			= new Panel();
		
	public MeinFenster()
	{
		super("MeinFenster");
		this.setSize(400,350);
		this.setLocation(50, 50);
		this.setBackground(Color.LIGHT_GRAY);				
		
	//Layout festlegen
		this.p_radius.setLayout(new GridLayout(1,2));
		this.p_radius.add(l_radius);
		this.p_radius.add(tf_radius);
		this.p_hoehe.setLayout(new GridLayout(1,2));
		this.p_hoehe.add(l_hoehe);
		this.p_hoehe.add(tf_hoehe);
				
		this.p_eingabebereich.setLayout(new GridLayout (5,3));
		this.p_eingabebereich.add(cb_b_umfang);			this.p_eingabebereich.add(cb_e_mm);		this.p_eingabebereich.add(p_radius);
		this.p_eingabebereich.add(cb_b_grundflaeche);	this.p_eingabebereich.add(cb_e_cm);		this.p_eingabebereich.add(p_hoehe);
		this.p_eingabebereich.add(cb_b_mantel);			this.p_eingabebereich.add(cb_e_dm);		this.p_eingabebereich.add(l_ergebnis);
		this.p_eingabebereich.add(cb_b_oberflaeche);	this.p_eingabebereich.add(cb_e_m);		this.p_eingabebereich.add(tf_ergebnis);
		this.p_eingabebereich.add(cb_b_volumen);		this.p_eingabebereich.add(cb_e_km);		this.p_eingabebereich.add(b_berechne);
		
		this.setLayout(new BorderLayout());
		this.add(BorderLayout.PAGE_START, this.p_eingabebereich);
		
	// Listener registrieren		
		this.cb_b_umfang.addItemListener(new MyItemListener());
		this.cb_b_grundflaeche.addItemListener(new MyItemListener());
		this.cb_b_mantel.addItemListener(new MyItemListener());
		this.cb_b_oberflaeche.addItemListener(new MyItemListener());
		this.cb_b_volumen.addItemListener(new MyItemListener());		
		
		this.cb_e_mm.addItemListener(new MyItemListener());
		this.cb_e_cm.addItemListener(new MyItemListener());
		this.cb_e_dm.addItemListener(new MyItemListener());
		this.cb_e_m.addItemListener(new MyItemListener());
		this.cb_e_km.addItemListener(new MyItemListener());
		
		this.b_berechne.addActionListener(this);
		
		this.addWindowListener(new WindowAdapter()
		{	public void windowClosing(WindowEvent we)
			{	System.exit(0);		}
		}	);
		
		this.setVisible(true);
	}
		
	public void paint(Graphics g)
	{
		int xPos = 150;
		int yPos = 170;
		int bPos = 100;
		int hPos = 25;
		
		g.setColor(Color.WHITE); 
		g.fillRect(xPos, yPos+hPos, bPos, 4*hPos);
		g.setColor(Color.BLACK);
		g.drawRect(xPos, yPos+hPos, bPos, 4*hPos);
		g.setColor(Color.WHITE);
		g.fillOval(xPos, yPos, bPos, 2*hPos);
		g.fillOval(xPos, yPos+4*hPos, bPos, 2*hPos);
		g.setColor(Color.BLACK);
		g.drawOval(xPos, yPos, bPos, 2*hPos);
		g.drawOval(xPos, yPos+4*hPos, bPos, 2*hPos);		
		
		switch (berechnung)
		{
		case 'U':	// Umvfang 	
			g.setColor(Color.RED);
			g.drawOval(xPos, yPos+4*hPos, bPos, 2*hPos);
			g.setColor(Color.BLACK);
			g.drawString("Umfang", xPos+hPos, yPos+hPos);
			break;
		case 'G': 	// Grundflche
			g.setColor(Color.RED);
			g.fillOval(xPos, yPos+4*hPos, bPos, 2*hPos);
			g.setColor(Color.BLACK);
			g.drawOval(xPos, yPos+4*hPos, bPos, 2*hPos);
			g.drawString("Grundflche", xPos+hPos, yPos+hPos);
			break;
		case 'M':	// Mantel
			g.setColor(Color.RED);
			g.fillRect(xPos, yPos+hPos, bPos, 4*hPos);
			g.setColor(Color.BLACK);
			g.drawRect(xPos, yPos+hPos, bPos, 4*hPos);
			g.setColor(Color.WHITE);
			g.fillOval(xPos, yPos, bPos, 2*hPos);
			g.setColor(Color.RED);
			g.fillOval(xPos, yPos+4*hPos, bPos, 2*hPos);
			g.setColor(Color.BLACK);
			g.drawOval(xPos, yPos, bPos, 2*hPos);
			g.drawOval(xPos, yPos+4*hPos, bPos, 2*hPos);	
			g.drawString("Mantel", xPos+hPos, yPos+hPos);
			break;
		case 'O':	// Oberflche	
			g.setColor(Color.RED);
			g.fillRect(xPos, yPos+hPos, bPos, 4*hPos);
			g.setColor(Color.BLACK);
			g.drawRect(xPos, yPos+hPos, bPos, 4*hPos);
			g.setColor(Color.RED);
			g.fillOval(xPos, yPos, bPos, 2*hPos);
			g.fillOval(xPos, yPos+4*hPos, bPos, 2*hPos);
			g.setColor(Color.BLACK);
			g.drawOval(xPos, yPos, bPos, 2*hPos);
			g.drawOval(xPos, yPos+4*hPos, bPos, 2*hPos);	
			g.drawString("Oberflche", xPos+hPos, yPos+hPos);
			break;
		case 'V':	// Volumen	
			g.setColor(Color.GREEN);
			g.fillRect(xPos, yPos+hPos, bPos, 4*hPos);
			g.setColor(Color.BLACK);
			g.drawRect(xPos, yPos+hPos, bPos, 4*hPos);
			g.setColor(Color.GREEN);
			g.fillOval(xPos, yPos, bPos, 2*hPos);
			g.fillOval(xPos, yPos+4*hPos, bPos, 2*hPos);
			g.setColor(Color.BLACK);
			g.drawOval(xPos, yPos, bPos, 2*hPos);
			g.drawOval(xPos, yPos+4*hPos, bPos, 2*hPos);	
			g.drawString("Volumen", xPos+hPos, yPos+hPos);
			break;
		}
	}
	
	public class MyItemListener implements ItemListener
	{
		public void itemStateChanged(ItemEvent ie)
		{
			if (ie.getSource() == cb_b_umfang)			berechnung 	= 'U';
			if (ie.getSource() == cb_b_grundflaeche)	berechnung 	= 'G';
			if (ie.getSource() == cb_b_mantel)			berechnung 	= 'M';
			if (ie.getSource() == cb_b_oberflaeche)		berechnung 	= 'O';
			if (ie.getSource() == cb_b_volumen)			berechnung 	= 'V';
			if (ie.getSource() == cb_e_mm)				einheit 	= "mm";
			if (ie.getSource() == cb_e_cm)				einheit 	= "cm";
			if (ie.getSource() == cb_e_dm)				einheit 	= "dm";
			if (ie.getSource() == cb_e_m)				einheit 	= "m";
			if (ie.getSource() == cb_e_km)				einheit 	= "km";		
			
			tf_ergebnis.setText(" ");
			repaint();
		}
	}
	
	public void actionPerformed(ActionEvent e) 
	{
		double radius 		= Double.valueOf(tf_radius.getText()).doubleValue();
		double hoehe  		= Double.valueOf(tf_hoehe.getText()).doubleValue();
		double ergebnis		= 0.0d;
		String hoch			= "";
		
		
		switch (berechnung)
		{
		case 'U':	hoch=""; 	ergebnis = 2 * Math.PI * radius;					break;
		case 'G':	hoch="^2"; 	ergebnis = Math.PI * radius * radius;				break;
		case 'M':	hoch="^2";	ergebnis = 2 * Math.PI * radius * hoehe;			break;
		case 'O':	hoch="^2";	ergebnis = 2 * Math.PI * radius * (radius + hoehe);	break;
		case 'V':	hoch="^3";	ergebnis = Math.PI * radius * radius * hoehe;		break;
		}
		
		ergebnis = (double)((int)(ergebnis * 100))/100;
		
		
		tf_ergebnis.setText(String.valueOf(ergebnis) + " " + einheit + hoch);
		
		repaint();
	}
}
