package a1205_f_Kryptographie_Teil2;

import java.awt.event.*;
import java.io.File;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 * Der Controller muss beide die View und das Model kennen
 * da dieser fr die Kommunikation zwischen den Beiden sorgt
 */
public class Controller
{
	private View view;
	private Model model;

	public Controller()
	{
		this.model 	= new Model();
		this.view	= new View();
		this.addListener();
	}
	
	private void addListener()
	{
		view.setActionListener(new MyActionListener());
		view.setFocusListener(new MyFocusListener());
	}
		
    class MyActionListener implements ActionListener
    {
        public void actionPerformed(ActionEvent ae) 
        {
        	switch (ae.getActionCommand())
        	{
        		case "Quelldatei":
        		{
        			JFileChooser fc = new JFileChooser();
        			fc.setFileFilter(new FileNameExtensionFilter("Textdateien", "txt"));

        			int status = fc.showOpenDialog(null);

        			if (status == JFileChooser.APPROVE_OPTION)
        			{
        				File file = fc.getSelectedFile();
        				view.setQuelle(file.getPath());
        			} 
        			else
        			{
        				JOptionPane.showMessageDialog(null,
        			            "Dateiauswahl fehlgeschlagen!",
        			            "Fehler",					      
        					    JOptionPane.ERROR_MESSAGE); // Nachrichtentyp
        			}
        			break;
        		}
        		case "Zieldatei":
        		{
        			JFileChooser fc = new JFileChooser();
        			fc.setFileFilter(new FileNameExtensionFilter("Textdateien", "txt"));

        			int status = fc.showSaveDialog(null);

        			if (status == JFileChooser.APPROVE_OPTION)
        			{
        				File file = fc.getSelectedFile();
        				view.setZiel(file.getPath());
        			} 
        			else
        			{
        				JOptionPane.showMessageDialog(null,
        			            "Dateiauswahl fehlgeschlagen!",
        			            "Fehler",					      
        					    JOptionPane.ERROR_MESSAGE); // Nachrichtentyp
        			}
        			break;
        		}
        		case "verschlsseln":
        		{
        			String quelle 		= view.getQuelle();
        			String ziel 		= view.getZiel();
        			String schluessel 	= view.getSchuessel();
        			
        			int i_schluessel = 0;
        		        		
        			if (!schluessel.equals("")) i_schluessel = Integer.valueOf(schluessel); 
        		        		
        			model.verschluesseln(i_schluessel, quelle, ziel);
        			break;
        		}
        		case "entschlsseln":
        		{
        			String quelle 		= view.getQuelle();
        			String ziel 		= view.getZiel();
        			String schluessel 	= view.getSchuessel();
        		
        			int i_schluessel = 0;
        		        		
        			if (!schluessel.equals("")) i_schluessel = Integer.valueOf(schluessel); 
        		        		
        			model.entschluesseln(i_schluessel, quelle, ziel);
        			break;
        		}
        	}
        }
    }
    
    class MyFocusListener extends FocusAdapter
	{
    	public void focusGained (FocusEvent fe)
    	{
    		String textfeld = " ";
    		if (fe.getSource() == "tf_quelle") 		textfeld = "quelle";
    		if (fe.getSource() == "tf_ziel") 		textfeld = "ziel";
    		if (fe.getSource() == "tf_schluessel") 	textfeld = "schluessel";    		
    		view.resetView(textfeld);
    	}
	}
}
