package a1205_f_Kryptographie_Teil2;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;


import javax.swing.JOptionPane;

public class Model
{
	public boolean verschluesseln(int schluessel, String quelle, String ziel)
	{
		System.out.println("Quelle: " + quelle);
		System.out.println("Ziel: " + ziel);
		System.out.println("Schlssel:" + schluessel);
		
		
		Path q = Paths.get(quelle);
		
		// Kontrolle Quelldatei
		if (	!(Files.exists(q)
				&&	Files.isRegularFile(q)
				&&	Files.isReadable(q)))
		{
			JOptionPane.showMessageDialog(null,
		            "Quelldatei existiert nicht!",
		            "Warnung",					      
				    JOptionPane.WARNING_MESSAGE); // Nachrichtentyp
			return false;
		}
		
		Path z = Paths.get(ziel);
				
		// Kontrolle Zieldatei
		if (Files.exists(z))
		{
		   	int a = JOptionPane.showConfirmDialog(null,
		     		"Soll die Zieldatei berschrieben werden?",
		            "Zieldatei existiert!",
		            JOptionPane.YES_NO_OPTION); // Nachrichtentyp
		   	
		   	System.out.println("A: " + a);
		   	if (a == 1) return false;
		}
		
		try
		{
			System.out.println("Hallo---");
			
			BufferedReader reader = Files.newBufferedReader(q, Charset.defaultCharset());
			BufferedWriter writer = Files.newBufferedWriter(z, Charset.defaultCharset());
			
			try
			{
			// Beginn der Verschlsselung	
				String 	sQuelle = null;
				String 	sZiel;
				char	cQuelle;
				char	cZiel;
					
				while ((sQuelle = reader.readLine()) != null)
				{
					sZiel = "";
					for (int i=0; i<sQuelle.length(); i++)
					{
						cQuelle	= sQuelle.charAt(i);
						cZiel 	= (char)((int)cQuelle + schluessel);
						sZiel = sZiel + cZiel;
					}
					writer.write(sZiel);
					writer.newLine();
				}
			}
			catch (IOException io)
			{
				JOptionPane.showMessageDialog(null,
			            "Verschlsselung fehlgeschlagen! " + io.getMessage(),
			            "Fehler",					      
					    JOptionPane.ERROR_MESSAGE); // Nachrichtentyp
				return false;
			}
			finally
			{
				reader.close();
				writer.close();
			}
		}
		catch (IOException io)
		{
			
			JOptionPane.showMessageDialog(null,
		            "Verschlsselung fehlgeschlagen! "+ io.getMessage(),
		            "Fehler",					      
				    JOptionPane.ERROR_MESSAGE); // Nachrichtentyp
			return false;
		}
		
		return true;
	}
	
	public boolean entschluesseln(int schluessel, String quelle, String ziel)
	{
		return verschluesseln (schluessel * -1, quelle, ziel); 	
	}
}
