package a1205_f_Kryptographie_Teil2;

import java.awt.*; 
import java.awt.event.*;
import javax.swing.*;

/* Die View-Klasse enthlt nur die Prsentation
 * hier sollte man keinerlei Programmlogik finden
 * alle Berechnungen und Reaktionen auf Benutzeraktionen
 * sollten allesammt im Controller stehen
 */
public class View 
{
	JFrame frame;
	
	private JTextField 	tf_quelle 			= new JTextField ("", 10);
	private JTextField 	tf_ziel 			= new JTextField ("", 10);
	private JTextField 	tf_schluessel 		= new JTextField ("0", 10);
	private JLabel 		l_schluessel		= new JLabel ("Schlssel");
	private JButton 	b_quelle			= new JButton ("Quelldatei");
	private JButton		b_ziel				= new JButton ("Zieldatei");
	private JButton		b_verschluesseln	= new JButton ("verschlsseln");
	private JButton		b_entschluesseln	= new JButton ("entschlsseln");
	private JPanel 		p1 					= new JPanel ();
	private JPanel 		p2 					= new JPanel ();
	private JPanel 		p3 					= new JPanel ();
	private JPanel 		p4 					= new JPanel ();
	
	public View() //Konstruktor
	{
		frame = new JFrame("Kryptographie");
		p1.setLayout (new GridLayout(2,2));
		p1.add (l_schluessel); p1.add (tf_schluessel);		
		p1.add (b_verschluesseln); p1.add (b_entschluesseln);	
		
		p2.setLayout (new GridLayout(2,1));
		p2.add (b_quelle);
		p2.add (b_ziel);
		
		p3.setLayout (new GridLayout(2,1));
		p3.add (tf_quelle);
		p3.add (tf_ziel);
		
		p4.setLayout(new BorderLayout());
		p4.add (BorderLayout.LINE_START, p2);
		p4.add (BorderLayout.CENTER,p3);
		
		Container cp = frame.getContentPane();
		cp.setLayout (new BorderLayout());
		cp.add (BorderLayout.PAGE_START, p4);
		cp.add (BorderLayout.PAGE_END, p1);
		cp.setBackground (Color.lightGray);
		
		frame.setSize (300,150);
		frame.setBackground(Color.LIGHT_GRAY);
		frame.setVisible (true);
	}
	
	//Schnittstelle zu den Textfeldern
	public void resetView(String textfeld)
	{
		switch(textfeld)
		{
		case "quelle": 		this.tf_quelle.setText("");			break;
		case "ziel":    	this.tf_ziel.setText("");			break;
		case "schluessel":	this.tf_schluessel.setText("0");	break;
		}
	}
	
	public String getQuelle()
	{
		return this.tf_quelle.getText();
	}
	
	public String getZiel()
	{
		return this.tf_ziel.getText();
	}
	
	public String getSchuessel()
	{
		return this.tf_schluessel.getText();
	}
	
	public void setQuelle(String quelle)
	{
		this.tf_quelle.setText(quelle);
	}
	
	public void setZiel(String ziel)
	{
		this.tf_ziel.setText(ziel);
	}	
	
	public void setSchluessel(String schluessel)
	{
		this.tf_schluessel.setText(schluessel);
	}	
	
	//Schnittstelle zu den Listenern
    public void setActionListener(ActionListener al)
    {
        this.b_quelle.addActionListener(al);
        this.b_ziel.addActionListener(al);
        this.b_verschluesseln.addActionListener(al);
        this.b_entschluesseln.addActionListener(al);
    }
    
    public void setFocusListener(FocusListener fl)
    {
        this.tf_quelle.addFocusListener(fl);
        this.tf_ziel.addFocusListener(fl);
        this.tf_schluessel.addFocusListener(fl);
    }
}
