package a2003_u_XML_Zusatzaufgabe_Wuerfel;

import java.awt.Color;
import java.awt.Graphics2D;

import java.io.File;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.XMLConstants;
import javax.xml.parsers.DocumentBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

public class MeinProgramm extends _Panel
{
	private static final long serialVersionUID = 1L;

	public void meinProgramm(String[] args, // Programm Aufrufparameter
			Graphics2D g, // Universelles Zeichenobjekt
			int eingabeIndex, // Index der Eingabe
			String sEingabe, // Eingabe als Zeichenkette
			char cEingabe, // Erstes Zeichen der Eingabe
			double dEingabe, // Eingabe als Gleitkommazahl (wenn mglich!)
			int iEingabe) // Eingabe als ganze Zahl (wenn mglich!)
	{
		String xmlDokument = "src/a2004_u_XML_Wuerfel/Grafik.xml";
		String xmlSchema = "src/a2004_u_XML_Wuerfel/Grafik.xsd";

		try
		{
			// Schema s bestimmen und einlesen
			SchemaFactory sF = SchemaFactory
					.newInstance(XMLConstants.W3C_XML_SCHEMA_NS_URI);
			Source sS = new StreamSource(new File(xmlSchema));
			Schema s = sF.newSchema(sS);

			// Dokument d gegen s prfen und einlesen
			DocumentBuilderFactory dF = DocumentBuilderFactory.newInstance();
			dF.setNamespaceAware(true);
			dF.setSchema(s);
			DocumentBuilder dB = dF.newDocumentBuilder();
			Document d = dB.parse(xmlDokument);
			d.getDocumentElement().normalize();

			// XML-Dokument auswerten
			String root = d.getDocumentElement().getNodeName();
			System.out.println(
					"Root Element :" + root + "\n=====================");

			// Liste aller Texte anlegen
			NodeList l = d.getElementsByTagName("text");
			for (int i = 0; i < l.getLength(); i++)
			{
				Node n = l.item(i);
				Element e = (Element) n;
				// Test auslesen
				String wert = e.getTextContent();
				// Attribute bestimmen
				int x = Integer.parseInt(e.getAttribute("x"));
				int y = Integer.parseInt(e.getAttribute("y"));
				String fa = e.getAttribute("farbe");
				this.setColor(g, fa);				
				g.drawString(wert, x, y);
			}

			// Alle Grafikelemente bestimmen
			l = d.getElementsByTagName("grafik");
			for (int i = 0; i < l.getLength(); i++)
			{
				Node n = l.item(i);
				Element e = (Element) n;
				// Grafikattribute auslesen
				int x = Integer.parseInt(e.getAttribute("x"));
				int y = Integer.parseInt(e.getAttribute("y"));
				int b = Integer.parseInt(e.getAttribute("breite"));
				String fa = e.getAttribute("farbe");
				String fo = e.getAttribute("form");
				this.setColor(g, fa);
				switch (fo)
				{
				case "quadrat": g.fillRect(x, y, b, b);
				case "kreis":	g.fillOval(x, y, b, b);
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	
	public void setColor(Graphics2D g, String farbe)
	{
		Color c;
		
		switch (farbe)
		{
		case "blau": 	c = Color.BLUE; 	break;
		case "gruen": 	c = Color.GREEN; 	break;
		case "rot": 	c = Color.RED; 		break;
		case "gelb": 	c = Color.YELLOW;	break;
		default:		c = Color.BLACK;
		}
		g.setColor(c);
	}
}
