package a1103c_f_Umrechnen_VORLAGE;

import java.awt.*;
import java.awt.event.*;

public class MyFenster extends Frame implements ActionListener
{
	private static final long serialVersionUID = 1L;
	
	//Umrechnungskonstanten
	private final static float PS_TO_KW = 0.73f; 
	private final static float KW_TO_PS = 1.36f;
	
	private TextField ps, kw;
	private Button um, end;

	public MyFenster()
	{
		super("Umrechnen"); 
		ps = new TextField("", 10);
		kw = new TextField("", 10);
		um  = new Button("Umrechnen");
		end = new Button("Beenden");
		
		//Layout
		Panel p1 = new Panel(); 
		p1.setLayout(new GridLayout(1, 4));
		p1.add(ps);	p1.add(new Label("=PS"));
		p1.add(um);	p1.add(new Label("=KW"));
		Panel p2 = new Panel();
		p2.setLayout(new BorderLayout());
		p2.add(BorderLayout.CENTER, kw);
		p2.add(BorderLayout.LINE_END, end);
		this.setLayout(new BorderLayout()); 											
		this.add(BorderLayout.PAGE_START, p2);
		this.add(BorderLayout.PAGE_END, p1);

		//Listener registrieren
		um.addActionListener(this); // Listener registrieren
		ps.addFocusListener(new MyFocusListener());
		kw.addFocusListener(new MyFocusListener());
		this.addWindowListener(new MyWindowListener(true)); // MyWindowListener

		this.setBackground(Color.CYAN); // Sonstige Fenstereinstellungen
		this.setSize(300, 100);
		this.setVisible(true);
	}

	public void actionPerformed(ActionEvent e) 
	{
		if (e.getSource() == end)
		{
			System.exit(0);
		}
		if (e.getSource() == um)
		{
			String s_ps, s_kw;
			float f_ps, f_kw;

			// Texte einlesen
			s_ps = ps.getText();
			s_kw = kw.getText();

			if (!s_ps.equals("") && s_kw.equals(""))
			{
				f_ps = Float.valueOf(s_ps).floatValue();
				f_kw = PS_TO_KW * f_ps;
				s_kw = String.valueOf(f_kw);
				kw.setText(s_kw);
			}
			
			if (s_ps.equals("") && !s_kw.equals(""))
			{
				f_kw = Float.valueOf(s_kw).floatValue();
				f_ps = KW_TO_PS * f_kw;
				s_ps = String.valueOf(f_ps);
				ps.setText(s_ps);
			}
		}
	}

	class MyFocusListener extends FocusAdapter
	{
		public void focusGained(FocusEvent e)
		{
			ps.setText("");
			kw.setText(""); 
		}
	}

}
